using System;
using System.Xml;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary
{
	/// <summary>
	/// Factory class analyzing supplied XML node and creating appropriate RPC parameter objects.
	/// </summary>
	public class RpcParameterXmlFactory
	{		
		/// <summary>
		/// Default parameterless constructor added for extendibility.
		/// The only publicly visible method of this class is made instance virtual method, so
		/// it may be overriden by derived classes in the future.
		/// </summary>
		public RpcParameterXmlFactory() {}

		/// <summary>
		/// Analyzes supplied XML node, determines if it contains known type of RPC parameter
		/// and returns new instance of corresponding RPC parameter class deserialized from
		/// a given XML node.
		/// </summary>
		/// <param name="parameterNode">XML node to analyze and deserialize RPC parameter from.</param>
		/// <returns>New instance of corresponding RPC parameter class deserialized from a given XML node.</returns>
		public virtual RpcParameter ParseCreateRpcParameter( XmlNode parameterNode  )
		{
			if( parameterNode == null )
				throw( new ArgumentNullException( "parameterNode" ) );

			string _parameterTypeName = RpcParameter.XmlParseGetParameterTypeName( parameterNode );

			if( RpcStringParameter.DoesParameterTypeNameMatch( _parameterTypeName ) )
				return new RpcStringParameter( parameterNode );

			if( RpcArrayParameter.DoesParameterTypeNameMatch( _parameterTypeName ) )
				return new RpcArrayParameter( parameterNode );

			if( RpcRefParameter.DoesParameterTypeNameMatch( _parameterTypeName ) )
				return new RpcRefParameter( parameterNode );

			return null;
		}
	}
}
